Django Dummy Data Generator — All Countries Version
==================================================

Features
- Dropdown with all countries (from pycountry)
- Uses Faker localized locales when available (falls back to en_US)
- Generates address, city, postal code, phone (localized where possible)
- Web UI with searchable country dropdown and record count
- Management command to generate via CLI
- Outputs users.txt (JSON-lines), users.csv, manifest.json in ZIP

Quick start
1. python -m venv venv
2. source venv/bin/activate  # or venv\Scripts\activate on Windows
3. pip install -r requirements.txt
4. python manage.py migrate
5. python manage.py runserver
6. Open http://127.0.0.1:8000/

CLI usage example:
python manage.py generate_dummy --count 500 --country-code IN --output-dir ./output --hash

Notes
- Faker locale support varies by country; for many countries it will use an appropriate locale (e.g., en_US, en_GB, en_IN, fr_FR).
- Phone numbers: for many countries we prepend an international calling code when available; otherwise Faker's phone_number is used.
- If you need fully accurate national phone formatting for every country, consider installing and integrating the `phonenumbers` library.
